import * as React from 'react';
import { Err } from './index';

export type Props = { error: Err };

export function View({ error }: Props) {
  return (
    <div>
      <h2 style={{ textAlign: 'center', padding: 16, fontWeight: 500, fontSize: 22 }}>
        {'Sorry, an error occurred :('}
      </h2>
      <p style={{ textAlign: 'center', padding: 16, fontSize: 16 }}>{JSON.stringify(error)}</p>
    </div>
  );
}
