import _memoize from 'memoize-one';
import { isEqual } from 'lodash';


// Функция для сравнения аргументов
export type IsEqual = (a: ArrayLike<any>, b: ArrayLike<any>) => boolean;


// Мемоизация
export default function memoize<A>(func: () => A, isEqual_?: IsEqual): typeof func;
export default function memoize<A,B>(func: (a: A) => B, isEqual_?: IsEqual): typeof func;
export default function memoize<A,B,C>(func: (a: A, b: B) => C, isEqual_?: IsEqual): typeof func;
export default function memoize<A,B,C,D>(func: (a: A, b: B, c: C) => D, isEqual_?: IsEqual): typeof func;
export default function memoize<A,B,C,D,E>(func: (a: A, b: B, c: C, d: D) => E, isEqual_?: IsEqual): typeof func;
export default function memoize<A,B,C,D,E,F>(func: (a: A, b: B, c: C, d: D, e: E) => F, isEqual_?: IsEqual): typeof func;
export default function memoize<A,B,C,D,E,F,G>(func: (a: A, b: B, c: C, d: D, e: E, f: F) => G, isEqual_?: IsEqual): typeof func;
export default function memoize<A,B,C,D,E,F,G,H>(func: (a: A, b: B, c: C, d: D, e: E, f: F, g: G) => H, isEqual_?: IsEqual): typeof func;
export default function memoize<A>(func: (...args) => A, isEqual_?: IsEqual): typeof func {
  return _memoize(func, isEqual_ || isEqual);
}
