import memoize from '../functions/memoize';
import { ObjectKey, ObjectPath } from '../functions/get-at';
import { FieldProps } from '../create-form';


// Опции для `createForm`
export type CreateZoomOptions<T> = {
  validate?(value: T): any;
  disabled?(value: T): any;
  getValue: () => T;
  onValueChange(value: T): void;
  onValueChange(value: unknown, at: ObjectPath): void;
};


// Функция-хелпер для подключения полей ввода
export type Zoom<T> = {
  (): FieldProps<T>;
  <K1 extends keyof T>(...keys: [K1]): FieldProps<T[K1]>;
  <K1 extends keyof T, K2 extends keyof T[K1]>(...keys: [K1, K2]): FieldProps<T[K1][K2]>;
  <K1 extends keyof T, K2 extends keyof T[K1], K3 extends keyof T[K1][K2]>(...keys: [K1, K2, K3]): FieldProps<T[K1][K2][K3]>;
  <K1 extends keyof T, K2 extends keyof T[K1], K3 extends keyof T[K1][K2], K4 extends keyof T[K1][K2][K3]>(...keys: [K1, K2, K3, K4]): FieldProps<T[K1][K2][K3][K4]>;
};


// Функция-хелпер для подключения полей ввода
export default function createZoom<T>(options: CreateZoomOptions<T>): Zoom<T> {
  const { onValueChange, getValue } = options;
  return (...keys) => {
    const value = getValue();
    const error = options.validate ? options.validate(value) : {};
    const disabled = options.disabled ? options.disabled(value) : {};
    const zoomedError = zoomAny(keys, error);
    
    return {
      value: zoomAny(keys, value),
      error: zoomedError,
      disabled: zoomAny(keys, disabled),
      onValueChange: zoomOnChange(keys, onValueChange),
    };
  };
}


const zoomOnChange = memoize((path: ObjectKey[], onChange: ((x: any, at: ObjectPath) => void)|undefined) => {
  return (next, at=[]) => {
    onChange && onChange(next, [...path, ...at]);
  };
});


const zoomAny = memoize((path: ObjectKey[], input: any) => {
  let iter = input as any;
  for (const key of path) {
    if (typeof(iter) !== 'object' || iter === null) return iter;
    iter = iter[key];
  }
  return iter;
});
