import * as React from 'react';
import { isEqual } from 'lodash';
import { FieldProps, Modifier } from '~/fields';


// Props
export type Props = {
  delay?: number,
}


// Component
export class Debounce extends React.Component<Props> {
  value: any;
  prevContext: FieldProps;
  timer: number|null = null;
  callback: Function|null = null;
  
  projectContext = (context: FieldProps) => {
    if (!this.prevContext || !isEqual(context.value, this.prevContext.value)) {
      this.value = context.value;
    }
    this.prevContext = context;
    return {
      ...context,
      value: this.value,
      onValueChange: this.handleChange,
      onBlur: this.handleBlur,
    };
  };
  
  handleChange = (value) => {
    if (this.timer) clearTimeout(this.timer);
    this.value = value;
    this.forceUpdate();
    this.callback = () => {
      if (!this.prevContext) return;
      this.timer = null;
      this.callback = null;
      const { onValueChange } = this.prevContext;
      onValueChange && onValueChange(value);
    };
    this.timer = setTimeout(this.callback, this.props.delay || 500);
  };
  
  handleBlur = (e: React.ChangeEvent<HTMLInputElement>) => {
    this.callback && this.callback();
  };
  
  render() {
    return <Modifier proj={this.projectContext}>{this.props.children}</Modifier>;
  }
}

export default Debounce;;
