## Пример использования
```ts
import { makeGettext, withGettext, I18nString } from '~/gettext';

const gettext = makeGettext(require('./i18n.po.yml'));

// Отложенный перевод строк
function printStatus(status: 'buzy'|'idle'): I18nString {
    switch (status) {
        case 'buzy': return gettext('Buzy');
        case 'idle': return gettext('Idle');
    }
}

// Тип I18nString
// type I18nString = (locale?: string|LocaleCtx|null) => string;
// те функция, которая вернет строку если ей передать нужную локаль

console.log(printStatus('buzy')('ru-RU')); // => 'Занят'


// Эти поля должны присутствовать в `Props` для использования `withGettext`
export type Props = {
  __: Gettext;
  ctx: LocaleCtx;
};


class Widget extends React.Component<Props> {
    render() {
        const { __ } = this.props;
        return <div>
            {__('Hello, World!')}
        </div>;
    }
}
export default withGettext(gettext)(Widget);
// Или так
// export default withGettext(require('./i18n.po.yml'))(Widget);

```

## Формат *.po.yml 

> 2018-10-31 DEPRECATED: Решено использовать стантартный формат *.po

Альтернативный формат, для *.po файлов предназначен предназначен для
более простой манипуляции с gettext-данными, и для обеспечения
возможности хранения переводов вместе с UI-компонентами модуль


```yml
- "":
    locale: "ru-RU"
  "Accommodations": "Проживания"
  "Select guests": "Выберите гостя"
  "%podata":
    - msgid: "%d sec"
      msgid_plural: "%d sec"
      msgstr: ["%d секунда", "%d секунды", "%d секунд"]
      
    - msgid: "<b>%d</b>&ndash;<b>%d</b> of <b>%d</b>"
      msgid_plural: "<b>%d</b>&ndash;<b>%d</b> of <b>%d</b>"
      msgstr: ["<b>%d</b>&ndash;<b>%d</b> из <b>%d</b>", "<b>%d</b>&ndash;<b>%d</b> из <b>%d</b>", "<b>%d</b>&ndash;<b>%d</b> из <b>%d</b>" ]
```

В корне *.po.yml должен быть массив, каждый элемент которого
соответствует целому *.po файлу. 

```
- "":
    locale: "ru-RU"
```
в поле с пустым именем содержатся метаданные файла (как в секции msgid
"" в оригинальном *.po)


```
  "%podata":
    - msgid: "%d sec"
      msgid_plural: "%d sec"
      msgstr: ["%d секунда", "%d секунды", "%d секунд"]
```

Еще одно специальное поле в объекте внутри массива — `%podata` внутри
содержатся поля соответствующие записям из оригинального формата po
`msgid`, `msgid_plural`, `msgctx`, `msgstr`

```
- ""
    # ...
  "Accommodations": "Проживания"
  "Select guests": "Выберите гостя"
  

# Тоже самое в *.po
msgid "Accommodations"
msgstr "Проживания"

msgid "Select guests"
msgstr "Выберите гостя"
```

Остальные ключи внутри эелемента в корне массива соответствуют краткой
форме для записи в po в которой присутствуют только две строки `msgid` и `msgstr`
