import { Either } from  './either';


/** lens */
export class Lens<A,B> {
  static fromProp<T, K extends keyof T>(k: K): Lens<T, T[K]> {
    return new Lens((t: T) => t[k],  (tk, t) => ({ ...t as any, [k as string]: tk } as any as T ));
  }
  constructor(readonly get: (a: A) => B, readonly set: (a: A, b: B) => A) {}
  modify(a: A, f: (b: B) => B): A { return this.set(a, f(this.get(a))); }
  compose<C>(that: Lens<B,C>): Lens<A,C> { return new Lens((a: A) => that.get(this.get(a)), (a: A, c: C) => this.set(a, that.set(this.get(a), c))); }
}


/** contruct a lens */
export function lens<A,B>(getter: (a: A) => B, setter: (a: A, b: B) => A): Lens<A,B> {
  return new Lens(getter, setter);
}


/** prism */
export class Prism<A,B> {
  constructor(readonly match: (a: A) => Either<A,B>, readonly build: (b: B) => A) {}
}
