import * as r from '../router';
import * as readline from 'readline';


/// объявление парсера
const parser = r.oneOf(

  // #home
  r.tag('Home').path('/home'),

  // #shop?search=&limit=&offset=
  r.tag('Shop').path('/shop').params({
    search: r.string.withDefault(''),
    limit: r.nat.withDefault(100),
    offset: r.nat.withDefault(0),
  }),

  // #shop/:id
  r.tag('Shop/item').path('/shop').segment('id', r.string),
);


const rl = readline.createInterface({
  input: process.stdin,
  output: process.stdout
});


rl.setPrompt('Введите относительный url\n> ');
rl.on('line', answer => {
  const maybeRoute = parser.parseUrl(answer);
  if (maybeRoute.tag === 'Some') {
    console.log(maybeRoute.value);
  } else {
    console.log('404: страница не найдена :(');
  }
  rl.prompt();
});
rl.prompt();
