import { Problem } from '../../decoder';
import { Eff } from '../../eff';
import { Err as LocalStorageErr } from '../../persistent';
import { literal } from '../../types';

/**
 * Data конструктор `UnexpectedError` ошибок
 * @param error предположительно `Error`
 */
export function UnexpectedError(error: any) {
  return Object.freeze({ tag: literal('UnexpectedError'), error });
}
/**
 * Data конструктор `DecoderError` ошибок
 * @param error проблема из `decoder.validate`
 */
export function DecoderError(error: Problem) {
  return Object.freeze({ tag: literal('ValidationError'), error });
}
/**
 * Ошибка загрузки переводов для `gettext`
 * @param locale локаль при загрузке которой возникла ошибка
 */
export function TranslationLoadError(locale: string) {
  return Object.freeze({ tag: literal('TranslatonLoadError'), locale });
}
/**
 * Data-конструкто для `LocalStorageError` ошибок
 * @param error возможные ошибки при работе с `window.localStorage`
 */
export function LocalStorageError(error: LocalStorageErr) {
  return Object.freeze({ tag: literal('LocalStorageError'), error });
}
/**
 * Перечесление возможных ошибок приложения
 */
export type Err =
  | ReturnType<typeof UnexpectedError>
  | ReturnType<typeof DecoderError>
  | ReturnType<typeof TranslationLoadError>
  | ReturnType<typeof LocalStorageError>
  ;
/**
 * `Eff<Err, T>`, где `T` generic параметр `Async`
 */
export type Async<T> = Eff<Err, T>;
