import { configDecoder, infoDecoder, presetKeyDecoder } from '../../../config';
import * as cr from '../../config-reader';
import * as eff from '../../eff';
import * as either from '../../either';
import { Async, DecoderError } from '../error';

export type Config = typeof configDecoder['_A'];
export type Info = typeof infoDecoder['_A'];
export type PresetKey = typeof presetKeyDecoder['_A'];
export { configDecoder, infoDecoder, presetKeyDecoder };
/**
 * Контекст конфигурации проекта
 */
export type Ctx = Config & { bundle: Info };
// Сгенирированные через Webpack.DefinePlugin занчения
declare const __CONFIG__: any;
declare const __INFO__: any;
/**
 * Считывает конфигурации собранные в переменной `__CONFIG__` и информацию о сборке из переменной `__INFO__`
 * Позволяет переопределить значения `__CONFIG__` через `window.location.search`
 */
export function init(): Async<Ctx> {
  return either.ap(
    configDecoder.validateConfigs(
      cr.json(__CONFIG__),
      cr.queryString(window.location.search),
    ),
    infoDecoder.validate(__INFO__),
    (config, bundle) => ({ ...config, bundle }),
  ).fold(problem => eff.failure(DecoderError(problem)), eff.success);
}
