import * as React from 'react';
import Switch, { SwitchProps } from '@material-ui/core/Switch';
import { Theme } from '@material-ui/core/styles/createMuiTheme';
import withStyles, { WithStyles, StyleRules } from '@material-ui/core/styles/withStyles';
import { FieldProps } from './';
import * as classNames from 'classnames';
import { StandardProps } from '@material-ui/core';


// Props
export type Props = StandardProps<React.HTMLProps<HTMLDivElement>, ClassKey, 'value'> & FieldProps<boolean> & WithStyles<ClassKey> & {
  alignLeft?: boolean;
}


// Component
class BooleanField extends React.Component<Props> {
  handleChange: SwitchProps['onChange'] = (e, v) => {
    const { onValueChange } = this.props;
    onValueChange && onValueChange(v);
  };

  render() {
    const { ctx, value, classes, alignLeft, disabled, error, ...rest } = this.props as Props & WithStyles<ClassKey>;
    const rootClass = classNames(classes.root, {
      [classes.alignLeft]: alignLeft,
    });
    
    return <div {...rest}>
      <Switch
        className={rootClass}
        checked={value}
        onChange={this.handleChange}
        disabled={disabled}
      />
    </div>;
  }
}

export default withStyles(styles)(BooleanField);


// CSS классы
export type ClassKey = 'root'|'alignLeft';


// Styles
export function styles(theme: Theme): StyleRules<ClassKey> {
  const { unit } = theme.spacing;
  
  return {
    root: {
      '& > span:first-child': {
        height: unit * 4.5,
      }
    },

    alignLeft: {
      marginLeft: -13,
    },
  };
}
