import * as React from 'react';
import { AuthCtx as Ctx } from '~/context';
import { I18nString } from '~/gettext';
import { ObjectPath } from '~/utils';
const hoistNonReactStatics = require('hoist-non-react-statics');


export const { Provider, Consumer } = React.createContext<FieldProps>(void 0 as any);


// Контекст поля
export interface FieldProps<Value=any> {
  ctx?: Ctx;
  value?: Value;
  disabled?: Disabled;
  error?: Error|Validation<any>;
  FieldWrapper?: React.ComponentType;
  onValueChange?(value: Value, at?: ObjectPath): void;
  onFocus?(e?: React.SyntheticEvent): void;
  onBlur?(e?: React.SyntheticEvent): void;
  onClick?(e?: React.SyntheticEvent): void;
  onKeyDown?(e: React.KeyboardEvent): void;
  beginAdornments?: React.ReactNode;
  endAdornments?: React.ReactNode;
}


// Обертка для полей используемых внутри
export function withFieldContext<P extends FieldProps<any>, C extends React.ComponentType<P>>(Component: C): C {
  class WithFieldContext extends React.Component<P> {
    render() {
      return <Consumer>{this.renderer}</Consumer>;
    };

    renderer = (context: FieldProps) => {
      // @ts-ignore
      return React.createElement(Component, Object.assign({}, this.props, context));
    };
  }

  hoistNonReactStatics(WithFieldContext, Component);
  return WithFieldContext as any;
}



export interface ModifierProps {
  proj(input: FieldProps): FieldProps;
  children?: React.ReactNode;
}


// Модификация контекста
export class Modifier extends React.Component<ModifierProps> {
  render() {
    return <Consumer>{this.renderer}</Consumer>;
  }

  renderer = context => <Provider value={this.props.proj(context)}>{this.props.children}</Provider>
}


// Флаги активности
export interface DisabledRecord {
  [K: string]: Disabled;
}
export type Disabled = boolean|DisabledRecord;


// Ошибки в форме
export interface ErrorRecord {
  [K: string]: Error;
}
export type Error = boolean|string|ErrorRecord|I18nString;


export type Validation<A> = Partial<Record<keyof A, Error>>;
