
/**
 * Комбинация `Array.prototype.filter` и `Array.prototype.map` 
 */
export default function filterMap<A, B>(xs: A[], f: (a: A) => B|null): B[] {
  return xs.reduce<B[]>((acc, a) => { const b = f(a); b !== null && acc.push(b); return acc; }, []);
}
