import { Eff } from '../eff';
import * as eff from '../eff';
import { HttpError } from '../http';
import * as http from '../http';
import * as t from '../decode';


/// в отличии от других контейнеров, в `Eff` методы `map` и `chain` называются `mapEff` и `chainEff`
/// shim для nodejs
if (typeof(XMLHttpRequest) === 'undefined') global['XMLHttpRequest'] = require('xhr2');


/// создаем декодер для ответов api, api возвращает json в виде { "slip": { "advice": "…" } }
const adviceDecoder = t.at(['slip', 'advice'], t.string);


/// Eff<HttpError, string> эффект отправляет запрос к api, возвращает либо текст с советом либо `HttpError`
/// в отличии от промисов еффекты не начинают выполнение при создании
const getAdvice = http.get('http://api.adviceslip.com/advice').chainEff(http.expectJSON(adviceDecoder));


/// eff.ap выполняет переданные еффекты и применяет к результатам функцию переданную последним аргументом
const getThreeAdvices = eff.ap(getAdvice, getAdvice, getAdvice, (one, two, three) => ({ one, two, three }));


/// `chainEff` позволяет принять решение на основе результата предыдущего действия
/// getAdviceTwoHundreds отправляет запросы к api до тех пор пока суммарная длина советов не пресысит 200 символов
const loop = (acc: string[]) => getAdvice.chainEff(x => acc.reduce((len, x) => len + x.length, 0) + x.length > 200 ? eff.of(acc.concat([x])) : loop(acc.concat([x])));1
const getAdviceTwoHundreds = loop([]);


/// `Eff` — это просто алиас типа Observable<Either<error, success>> потому можно использовать любые операторы из rxjs
/// вызов `subscribe` инициирует выполнение действий
getAdvice.subscribe(ethr => console.log('getAdvice:', ethr), error => console.error(error));
getThreeAdvices.subscribe(ethr => console.log('getThreeAdvices:', ethr), error => console.error(error));
getAdviceTwoHundreds.subscribe(ethr => console.log('getAdviceTwoHundreds:', ethr), error => console.error(error));
