import * as React from 'react';
import { memoize } from 'lodash';
import { FieldProps } from '~/fields/context';
import filterMap from '~/functions/filter-map';
import { Modifier } from '~/fields';


// Props
export interface Props<A = any> {
  id?: string;
  source: A[];
}


// Component
export default class ArrayIDS<A = any> extends React.Component<Props<A>> {  
  projectContext = (input: FieldProps) => ({
    ...input,
    value: this.getValue(input.value),
    onValueChange: this.handleValueChange(input.onValueChange),
  });

  getValue = memoize(valueIn => {
    const { source } = this.props;
    const id = this.props.id || 'id';
    return filterMap(valueIn, x => source.find(s => s[id] === x) || null);
  });

  handleValueChange = memoize((onValueChange) => (valueOut: A[]) => {
    const id = this.props.id || 'id';
    onValueChange && onValueChange(valueOut ? valueOut.map(x => x[id]) : []);
  });

  render() {
    return <Modifier proj={this.projectContext}>{this.props.children}</Modifier>
  }
}
