import { withFieldContext } from '~/fields/context';
export * from './context';

export { default as In } from './In';
export { default as Zoom } from './Zoom';
export { default as Label } from './Label';
export { default as ResourceID } from './ResourceID';
export { default as ArrayIDS } from './ArrayIDS';
export { default as Debounce } from './Debounce';


import BooleanField_ from './BooleanField';
import MomentField_ from './MomentField';
import SelectField_ from './SelectField';
import TextField_ from './TextField';
import AutoComplete_ from './AutoComplete';
import MultiSelect_ from './MultiSelect';
import DebounceUN from './DebounceUN';


export const BooleanField = withFieldContext(BooleanField_) as typeof BooleanField_;
export const MomentField = withFieldContext(MomentField_) as typeof MomentField_;
export const SelectField = withFieldContext(SelectField_) as typeof SelectField_;
export const TextField = withFieldContext(TextField_) as typeof TextField_;
export const AutoComplete = withFieldContext(AutoComplete_) as typeof AutoComplete_;
export const MultiSelect = withFieldContext(MultiSelect_) as typeof MultiSelect_;


export const undecorated = {
  TextField: TextField_,
  SelectField: SelectField_,
  MomentField: MomentField_,
  BooleanField: BooleanField_,
  AutoComplete: AutoComplete_,
  MultiSelect: MultiSelect_,
  Debounce: DebounceUN,
};

