import * as React from 'react';
import * as classNames from 'classnames';
import { CircularProgress } from '@material-ui/core';
import withStyles, { WithStyles, StyleRules } from '@material-ui/core/styles/withStyles';
import { Theme } from '@material-ui/core/styles/createMuiTheme';


// Props
export interface Props {
  className?: string;
}


// Component
export function Spinner(props: Props & WithStyles<ClassKey>) {
  const { classes, className } = props;
  const rootClass = classNames(classes.root, className);

  return <div className={rootClass}>
    <div className={classes.wrapper}>
      <CircularProgress size={32} color="secondary"/>
      <h2 className={classes.title}>Please, wait…</h2>
    </div>
  </div>;
}

export default withStyles(styles)(Spinner);


// CSS классы
export type ClassKey = 'root'|'title'|'wrapper';


// Styles
export function styles(theme: Theme): StyleRules {
  return {
    root: {
      display: 'block',
      position: 'absolute',
      width: '100%',
      height: '100%',
    },

    title: {
      ...theme.typography.title,
    },

    wrapper: {
      width: '100%',
      position: 'absolute',
      top: '50%',
      transform: 'translateY(-50%)',
      textAlign: 'center',
    },
  };
}
