import { ObjectPath } from './get-at';
export { ObjectPath };


/**
 * Обновляет значение вложенного поля
 * ```ts
 * const a = { one: { two: { three: 42 } } };
 * const b = updateAt(['one', 'two', 'three'], 'four')(a);
 * // b => { one: { two: { three: 'four' } } }
 * ```
 */
export default function updateAt(at_: ObjectPath, value: any): <A>(obj: A) => A {
  const at = Array.isArray(at_) ? at_ : [at_];
  return obj => {
    let stack: any[] = [obj];
    let tail: any = stack[0];
    for (const k of at) {
      if (!tail.hasOwnProperty(k)) return obj; // Поле отсутствует
      stack.push(tail[k]);
      tail = tail[k];
    }
    return stack.reduceRight((acc, x, idx) => {
      if (idx === stack.length - 1) return value;
      if (Array.isArray(x)) {
        const output = x.slice();
        output.splice(at[idx] as number, 1, acc);
        return output;
      }
      return ({ ...x, [at[idx]]: acc });
    }, value);
  };
}
