/**
 * Прямая композиция
 */
export default function compose<A, B>(f: (a: A) => B): (a: A) => B;
export default function compose<A, B, C>(f: (a: A) => B, g: (b: B) => C): (a: A) => C;
export default function compose<A, B, C, D>(f: (a: A) => B, g: (b: B) => C, h: (c: C) => D): (a: A) => D;
export default function compose<A, B, C, D, E>(f: (a: A) => B, g: (b: B) => C, h: (c: C) => D, j: (d: D) => E): (a: A) => E;
export default function compose(...funcs: Function[]): Function {
  return a => funcs.reduce((acc, f) => f(acc), a);
}
