import * as React from 'react';
import { Theme } from '@material-ui/core/styles/createMuiTheme';
import withStyles, { WithStyles, StyleRules } from '@material-ui/core/styles/withStyles';
import { StandardProps } from '@material-ui/core';
import * as classNames from 'classnames';


// props
export type Props = StandardProps<React.HTMLProps<HTMLLabelElement>, ClassKey> & WithStyles<ClassKey> & {
  focused?: boolean;
  error?: boolean;
  required?: boolean;
}


// component
class InputLabel extends React.Component<Props> {
  render() {
    const { classes, focused, error, required, ...rest } = this.props;
    const rootClass = classNames(classes.root, {
      [classes.focused]: focused,
      [classes.error]: error,
      [classes.required]: required,
    })
    
    return <label {...rest} className={rootClass} role="label"/>;
  }
}

export default withStyles(styles)(InputLabel);


// CSS классы
export type ClassKey = 'root'|'focused'|'error'|'required';


// styles
function styles(theme: Theme): StyleRules<ClassKey> {
  const { unit } = theme.spacing;
  
  return {
    root: {
      color: theme.palette.text.secondary,
      fontSize: theme.typography.pxToRem(13),
      fontWeight: 500,
      lineHeight: 1,
      padding: 0,
    },

    focused: {
      color: theme.palette.primary.main,
    },

    error: {
      color: theme.palette.error.main,
    },

    required: {
      '&:after': {
        content: '"*"',
        position: 'relative',
        top: 2,
        transform: 'scale(1.5)', 
        marginLeft: unit - 2,
        display: 'inline-block',
      },
    },
  };
}
