import * as React from 'react';
import Icon, { IconProps } from '@material-ui/core/Icon';
import withStyles, { WithStyles, StyleRules } from '@material-ui/core/styles/withStyles';
import { Theme } from '@material-ui/core/styles/createMuiTheme';
import * as classNames from 'classnames';


// Component
class IconComponent  extends React.Component<IconProps & WithStyles> {
  render() {
    const { classes, className } = this.props;
    const rootClass = classNames(className, {
      [classes.button]: 'onClick' in this.props
    });
    // @ts-ignore
    return React.createElement(Icon, { ...this.props, className: rootClass });
  }
}

export default withStyles(styles)(IconComponent);



// Styles
export function styles(theme: Theme): StyleRules {
  // const { unit } = theme.spacing;

  return {
    button: {
      cursor: 'pointer',
      color: theme.palette.text.secondary,
      '&:hover': {
        color: theme.palette.text.primary,
      }
    },
  };
}
