
/** function to compare two argument lists */
export type ArgsComparator = (xs: IArguments, ys: IArguments) => boolean;


/** compare arguments as references */
export function cmpPtr(xs: IArguments, ys: IArguments): boolean {
  if (xs.length !== ys.length) return false;
  for (let i in xs) { if (xs[i] !== ys[i]) return false; }
  return true;
}


/** cheap partial memoisation, only the last call results are preserved */
export default function memoize<A>(func: () => A, cmp?: ArgsComparator): typeof func;
export default function memoize<A,B>(func: (a: A) => B, cmp?: ArgsComparator): typeof func;
export default function memoize<A,B,C>(func: (a: A, b: B) => C, cmp?: ArgsComparator): typeof func;
export default function memoize<A,B,C,D>(func: (a: A, b: B, c: C) => D, cmp?: ArgsComparator): typeof func;
export default function memoize<A,B,C,D,E>(func: (a: A, b: B, c: C, d: D) => E, cmp?: ArgsComparator): typeof func;
export default function memoize<A,B,C,D,E,F>(func: (a: A, b: B, c: C, d: D, e: E) => F, cmp?: ArgsComparator): typeof func;
export default function memoize<A,B,C,D,E,F,G>(func: (a: A, b: B, c: C, d: D, e: E, f: F) => G, cmp?: ArgsComparator): typeof func;
export default function memoize<A>(func: (...args) => A, cmp: ArgsComparator = cmpPtr): typeof func {
  let lastArguments: IArguments|null = null;
  let lastResult: any = undefined;
  return function(this: any) {
    const result = lastArguments && cmp(lastArguments, arguments) ? lastResult : func.apply(this, arguments);
    lastResult = result;
    lastArguments = arguments;
    return result;
  };
}
