/**
 * Функции для работы с тэгами локали в формате BCP47
 * @see http://tools.ietf.org/html/bcp47
 */

/**
 * Принимает локаль в формате BCP47 или в формате POSIX (со знаком
 * подчеркивания в качестве разделителя), нормализует в BCP47
 * @param {string} locale - строка локали в POSIX или BCP47
 * @return {string} локаль в формате BCP47
 */
export function normalizeLocale(locale) {
  return locale.replace(/(.+)_/g, '$1-');
}

/**
 * @param {string} locale - локаль в формате BCP47 для поиска
 * @param {array} availableLocales - массив доступных локалей в формате BCP47
 * @return {string|undefined} locale если эта локаль есть в списке
 * availableLocales, иначе наиболее подходящаяя локаль из этого списка
 */
export function lookupLocale(locale, availableLocales) {
  if (availableLocales.findIndex((l) => (l === locale)) !== -1) {
    return locale; // locale присутствует в списке доступных локалей
  }
  
  const chunks = locale.split('-');
  const similarLocale = availableLocales.find((l) => (l.startsWith(chunks[0])));
  if (similarLocale !== undefined) return similarLocale;

  return undefined;
}
