## Пример использования
```ts
import { makeGettext, withGettext, I18nString } from '~/gettext';

const gettext = makeGettext(require('./i18n));

// Отложенный перевод строк
function printStatus(status: 'buzy'|'idle'): I18nString {
    switch (status) {
        case 'buzy': return gettext('Buzy');
        case 'idle': return gettext('Idle');
    }
}

// Тип I18nString
// type I18nString = (locale?: string|LocaleCtx|null) => string;
// те функция, которая вернет строку если ей передать нужную локаль

console.log(printStatus('buzy')('ru-RU')); // => 'Занят'


// Эти поля должны присутствовать в `Props` для использования `withGettext`
export type Props = {
  __: Gettext;
  ctx: LocaleCtx;
};


class Widget extends React.Component<Props> {
    render() {
        const { __ } = this.props;
        return <div>
            {__('Hello, World!')}
        </div>;
    }
}
export default withGettext(gettext)(Widget);
// Или так
// export default withGettext(require('./i18n.po.yml'))(Widget);

```

