import * as React from 'react';
import { isObservable, Observable } from 'rxjs';


// Props
export interface Props<A = any> {
  to: EventTarget|Observable<A>;
  event?: string;
  handler(x: A): void;
}


// Component
class Sub extends React.Component<Props, {}> {
  unlisten?: Function|null;

  componentDidMount() {
    this.listen(this.props);
  }

  componentWillReceiveProps(props) {
    if (this.props.to !== props.to) {
      this.unlisten && this.unlisten();
      this.listen(props);
    }
  }

  componentWillUnmount() {
    this.unlisten && this.unlisten();
  }

  listen(props: Props) {
    const { to, event } = props;
    if (isObservable(to)) {
      const subscription = to.subscribe(this.handler);
      this.unlisten = () => subscription.unsubscribe();
    } else {
      if (!event) throw new Error('Sub: unspecified `event`');
      (to as EventTarget).addEventListener(event, this.handler);
      this.unlisten = () => (to as EventTarget).removeEventListener(event, this.handler);
    }
  }

  handler = e => { this.props.handler(e); }

  render() { return null as any; }
}

export default Sub;
