import { AuthCtx as Ctx } from '~/context';
import { I18nString } from '~/gettext';
import { ObjectPath } from '~/functions/get-at';


// Контекст поля
export interface FieldProps<T = any> {
  ctx?: Ctx;
  value: T;
  disabled?: Disabled;
  // Здесь должен передавться результат `validate` те `Validation<A>`
  error?: Error;
  onValueChange?(value: T): void;
  onValueChange?(value: any, at?: ObjectPath): void;
}


// Флаги активности
export type Disabled = boolean|object;


// Ошибки в поле
export type Error = boolean|string|object|I18nString;


// Валидация формы
export type Validation<A> = Partial<Record<keyof A, Error>>;
