import { Update } from './';
import Monad from 'burrido';


// Do notation
export const { Do } = Monad({
  pure: Update.of,
  bind: (m, proj) => m.chain(proj),
});
Update.Do = Do;


declare module "./" {
  interface UpdateStatic {
    Do<State, Result>(iter: () => IterableIterator<Update<any, any>>): Update<State, Result>;
  }
  interface BoundStatics<State> {
    Do<Result>(iter: () => IterableIterator<Update<any, any>>): Update<State, Result>;
  }
}


