import * as React from 'react';
import * as classNames from 'classnames';
import { fade } from '@material-ui/core/styles/colorManipulator';
import CircularProgress from '@material-ui/core/CircularProgress';
import withStyles, { WithStyles, StyleRules } from '@material-ui/core/styles/withStyles';
import { StandardProps } from '@material-ui/core';
import { Theme } from '@material-ui/core/styles/createMuiTheme';


// Props
export type Props = StandardProps<React.HTMLProps<HTMLDivElement>, ClassKey> & {
  pending: boolean;
}


// Component
function PendingOverlay(props: Props & WithStyles<ClassKey>) {
  const { classes, className, ...rest } = props;
  const rootClass = classNames(classes.root, className, { [classes.pending]: props.pending });
  // @ts-ignore
  return <div {...rest} className={rootClass}>{props.pending && <CircularProgress/>}</div>;
}

export default withStyles(styles)(PendingOverlay);


// CSS классы
export type ClassKey = 'root'|'pending';


// Styles
export function styles(theme: Theme): StyleRules<ClassKey> {
  return {
    root: {
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      position: 'absolute',
      top: 0,
      left: 0,
      width: '100%',
      height: '100%',
      background: fade(theme.palette.background.paper, 0.57),
      zIndex: 1000,
      visibility: 'hidden',
      '&$pending': {
        visibility: 'visible',
      },
    },
    
    pending: {},
  };
}
