const path = require('path');
const fs = require('fs');
const webpack = require('webpack');
const tsConfig = require('./tsconfig.json');


module.exports = function(env={}) {
  const entry = env.entry || './index.tsx';
  const output = path.resolve(__dirname);
  return {
    context: path.resolve(__dirname),
    entry: { entry: [entry], },
    output: {
      path: output,
      filename: '[name].bundle.js',
    },
    module: {
      loaders: [{
        test: /\.tsx?$/,
        loader: 'ts-loader',
        options: {
          compilerOptions: tsConfig.compilerOptions,
          transpileOnly: env.hasOwnProperty('transpileOnly') ? env.transpileOnly : true,
        },
      }],
    },
    resolve: {
      extensions: ['.js', '.jsx', '.json', '.ts', '.tsx'],
      alias: {
        react: path.resolve(__dirname, 'node_modules/react'),
      },
    },
  };
};
