import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { Update } from '../';
import '../burrido';
import * as http from '../../http';
import { InputHTMLAttributes } from 'react';


type Err = http.HttpError;

type Props = {
};

type State = {
  pending: boolean;
  search: string;
  response?: http.Response;
};

const U = Update.bind<Err, State>();


class Widget extends Update.Component<Err, Props, State> {
  state: State = { search: '', pending: false };
  
  handleNameChange: InputHTMLAttributes<HTMLInputElement>['onChange'] = (e) => this.setState({ search: e.target.value });

  handleSubmit = (e: React.FormEvent) => this.setState(U.Do<void>(function*() {
    const { search: q }: State = yield U.get;
    const response = yield U.effect(http.get(http.join('https://api.github.com/search/repositories', { q }))).pending();
    yield U.patch({ response });
  }));
  
  render() {
    const { search, response, pending } = this.state;
    return <div>
      <form onSubmit={e => (e.preventDefault(), !pending && this.handleSubmit(e))}>
        <input value={search} onChange={this.handleNameChange} placeholder="Github search"/>
        <button type="submit" disabled={pending}>{pending ? 'Please, wait…' : 'Go'}</button>
      </form>
      <textarea value={JSON.stringify(response)} readOnly/>
    </div>;
  }
}


ReactDOM.render(<Widget/>, document.getElementById('app'));
