import { Update } from './';
import Monad from 'burrido';


// Do notation
export const { Do } = Monad({
  pure: Update.of,
  bind: (m, proj) => m.chain(proj),
});
Update.Do = Do;


declare module "./" {
  interface UpdateStatic {
    Do<State, Result>(iter: () => IterableIterator<Update<Error, any, any>>): Update<Error, State, Result>;
  }
  interface BoundStatics<Error, State> {
    Do<Result>(iter: () => IterableIterator<Update<Error, any, any>>): Update<Error, State, Result>;
  }
}


