## Пример использования
```ts
import { Transaction, withGettext, I18nString } from '~/gettext';

const translations = Transaction.fromJed(require('./i18n'));

// Отложенный перевод строк
function printStatus(status: 'buzy'|'idle'): I18nString {
    const { __ } = translations;
    switch (status) {
        case 'buzy': return __('Buzy');
        case 'idle': return __('Idle');
    }
}

// Тип I18nString
// type I18nString = (locale?: string|LocaleCtx|null) => string;
// те функция, которая вернет строку если ей передать нужную локаль

console.log(printStatus('buzy')('ru-RU')); // => 'Занят'


// Эти поля должны присутствовать в `Props` для использования `withGettext`
export type Props = {
  __: Gettext;
  ctx: LocaleCtx;
};


class Widget extends React.Component<Props> {
    render() {
        const { __ } = this.props;
        return <div>
            {__('Hello, World!')}
        </div>;
    }
}
export default withGettext(translations)(Widget);
// Или так
// export default withGettext(require('./i18n'))(Widget);

```

