import * as React from 'react';
import { AuthCtx as Ctx } from '~/context';
import { I18nString } from '~/gettext';
import { ObjectPath } from '~/functions/get-at';


export const { Provider, Consumer } = React.createContext<FieldProps>(void 0 as any);


// Контекст поля
export interface FieldProps<Value=any> {
  ctx?: Ctx;
  value: Value;
  disabled?: Disabled;
  error?: Error|Validation<any>;
  onValueChange?(value: Value): void;
  onValueChange?(value: any, at?: ObjectPath): void;
  onFocus?(e?: React.SyntheticEvent): void;
  onBlur?(e?: React.SyntheticEvent): void;
  onClick?(e?: React.SyntheticEvent): void;
  onKeyDown?(e: React.KeyboardEvent): void;
}


// Флаги активности
export interface DisabledRecord {
  [K: string]: Disabled;
}
export type Disabled = boolean|DisabledRecord;


// Ошибки в форме
export interface ErrorRecord {
  [K: string]: Error;
}
export type Error = boolean|string|ErrorRecord|I18nString;


export type Validation<A> = Partial<Record<keyof A, Error>>;
