
/**
 * Комбинация `Array.prototype.find` и `Array.prototype.map` 
 */
export default function findMap<A, B>(xs: A[], f: (a: A) => B|undefined): B|undefined {
  for (const x of xs) {
    const b_or_undefined = f(x);
    if (b_or_undefined !== undefined) return b_or_undefined;
  }
  return;
}
