import * as React from 'react';
import { Dialog, DialogTitle, DialogContent, DialogActions } from '@material-ui/core';
import { DialogProps } from '@material-ui/core/Dialog';
import withStyles, { WithStyles, StyleRules } from '@material-ui/core/styles/withStyles';
import { Theme } from '@material-ui/core/styles/createMuiTheme';
import * as classNames from 'classnames';
import Button from '@material-ui/core/Button';
import { LocaleCtx, Gettext, withGettext } from '~/gettext';


// Props
export interface Props {
  __: Gettext;
  ctx: LocaleCtx;
  className?: string;
  children: React.ReactNode;
  Confirmation: React.ReactType<ConfirmationProps>;
}


// State
export interface State {
  showConfirmation: boolean;
  args: any[];
}


// Component
export class WithConfirmation extends React.Component<Props & WithStyles, State> {
  state: State = { showConfirmation: false, args: [] };

  handleClick = (...args) => {
    this.setState({ args, showConfirmation: true });
  }

  handleConfirm = () => {
    const { children } = this.props;
    const { args } = this.state;
    if (children && children.hasOwnProperty('props') && typeof(children['props'].onClick) === 'function') children['props'].onClick.apply(undefined, args);
    this.setState({ showConfirmation: false, args: [] });
  };

  handleCancel = () => {
    this.setState({ showConfirmation: false, args: [] });
  };
  
  render() {
    const { __, ctx, classes, className, Confirmation, children: childrenProp } = this.props;
    const { showConfirmation } = this.state;
    const rootClass = classNames(classes.root, className);
    const children = childrenProp && childrenProp.hasOwnProperty('type') ? React.cloneElement(childrenProp as any, { onClick: this.handleClick }) : childrenProp;
    
    return <div className={rootClass}>
      {children}
      <Confirmation __={__}ctx={ctx} open={showConfirmation} onClose={this.handleCancel} onConfirm={this.handleConfirm}/>
    </div>;
  }
}

export default withStyles(styles)(withGettext(require('./i18n.po.yml'))(WithConfirmation));


// Props
export type ConfirmationProps = DialogProps & {
  __: Gettext;
  onConfirm?();
}


// Component
export const DeleteConfirmation = withStyles(styles)((props: ConfirmationProps & WithStyles) => {
  const { __, classes, onConfirm, ...other } = props;
  
  return (
    <Dialog {...other}>
      <DialogTitle>{__('Confirm deletion')}</DialogTitle>
      <DialogContent>
        {__('Are you sure you want to delete this item?')}
      </DialogContent>
      <DialogActions>
        <Button onClick={other.onClose}>{__('Cancel')}</Button>
        <Button onClick={onConfirm} color="primary">{__('Confirm')}</Button>
      </DialogActions>
    </Dialog>
  );
});


// Styles
export function styles(theme: Theme): StyleRules {
  return {
  };
}
