import * as React from 'react';
import { FieldProps } from './';
import * as F from './';
import { StandardProps } from '@material-ui/core';
import memoize from '~/functions/memoize';
import { ObjectKey, ObjectPath } from '~/functions/get-at';


// Props
export type Props = StandardProps<React.HTMLProps<HTMLDivElement>, string> & {
  in: Array<string|number>|string|number;
  onlyValue?: boolean;
  dontWrap?: boolean;
}


const zoomOnChange = memoize((path: ObjectKey[], onChange: ((x: any, at: ObjectPath) => void)|undefined) => {
  return (next, at=[]) => {
    onChange && onChange(next, [...path, ...at]);
  };
})

const zoomAny = memoize((path: ObjectKey[], input: any) => {
  let iter = input as any;
  for (const key of path) {
    if (typeof(iter) !== 'object' || iter === null) return iter;
    iter = iter[key];
  }
  return iter;
})


// Component
export default class Zoom extends React.Component<Props> {
  projectContext = (input: FieldProps) => {
    const { onlyValue } = this.props;
    const path = Array.isArray(this.props.in) ? this.props.in : [this.props.in];

    if (onlyValue) return {
      ...input,
      value: zoomAny(path, input.value),
      onValueChange: zoomOnChange(path, input.onValueChange),
    };
    else return {
      ...input,
      value: zoomAny(path, input.value),
      error: zoomAny(path, input.error),
      disabled: zoomAny(path, input.disabled),
      onValueChange: zoomOnChange(path, input.onValueChange),
    };
  }

  render() {
    const { dontWrap, children, in: in_, onlyValue, ...rest } = this.props;
    const dataIn = Array.isArray(in_) ? in_ : [in_];
    return <F.Modifier proj={this.projectContext}>
      {dontWrap ? children : <div {...rest} role="zoom" data-in={dataIn.join('-')}>{children}</div>}
    </F.Modifier>;
  }
}
