import * as React from 'react';
import { FieldProps } from './';
import * as F from './';


// Props
export type Props<A> = Partial<FieldProps<A>> & {
  Component: React.ReactType<FieldProps<A>>;
};


// Component
export default class WithContext<A> extends React.Component<Props<A>> {
  renderConsumer = (context: FieldProps<A>) => {
    const { Component, ...rest } = this.props;
    // @ts-ignore
    return React.createElement(Component, { ...context, ...rest });
  };
  
  render() {
    return <F.Consumer>{this.renderConsumer}</F.Consumer>;
  }
}
