/**
 * Ссылка на поле со вложенных объектах
 */
export type ObjectKey = string|number;
export type ObjectPath = ObjectKey|ObjectKey[];


/**
 * Получение значения вложенного поля
 * ```ts
 * const a = { one: { two: { three: 42 } };
 * const b = getAt(['one', 'two', 'three'])(a);
 * // b => 42
 * ```
 */
export default function getAt<R=any>(at_: ObjectPath): <A>(a: A) => R {
  const at = Array.isArray(at_) ? at_ : [at_];
  return a => {
    let iter = a as any as R;
    for (const k of at) {
      if (!iter.hasOwnProperty(k)) return undefined as any as R; // Поле отсутствует
      iter = iter[k];
    }
    return iter;
  }
}
