# frozen_string_literal: true

lib = File.expand_path('lib', __dir__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)
require 'ruby_with_elk/version'

Gem::Specification.new do |spec|
  spec.name          = 'ruby_with_elk'
  spec.version       = RubyWithElk::VERSION
  spec.authors       = ['Golubov Andrey']
  spec.email         = ['a.golubov@taxi-master.com']

  spec.summary       = 'Example use ELK stack with docker'
  spec.homepage      = 'https://git.bitmaster.ru/docker/ruby_with_elk'
  spec.license       = 'MIT'

  spec.files = Dir['lib/**/*', 'exe/*'] + [
    'Gemfile',
    'LICENSE',
    'Rakefile',
    'README.md',
    'ruby_with_elk.gemspec'
  ]

  spec.bindir        = 'exe'
  spec.executables   = spec.files.grep(%r{^exe/}) { |f| File.basename(f) }

  spec.require_paths = ['lib']

  spec.add_development_dependency 'bundler', '~> 2.0'
  spec.add_development_dependency 'rake'
  spec.add_development_dependency 'rspec'
  spec.add_development_dependency 'rubocop'

  spec.add_dependency 'logstash-logger'
  spec.add_dependency 'rack'
  spec.add_dependency 'puma'
end
